<?php
/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL ^ E_NOTICE ^ E_DEPRECATED);

// #################### DEFINE IMPORTANT CONSTANTS #######################
if ($_GET['do'] == 'doupload') {
	define('THIS_SCRIPT', 'login'); // Bypass board inactive warning
	define('LOCATION_BYPASS', true);
} else {
	define('THIS_SCRIPT', 'downloads');	
}

if ($_GET['do'] == 'listings' || $_GET['do'] == 'search') {
	define('ALLOW_BBCODE_BASIC', 		true);
	define('ALLOW_BBCODE_COLOR',	true);
	define('ALLOW_BBCODE_SIZE', 		false);
	define('ALLOW_BBCODE_FONT', 		false);
	define('ALLOW_BBCODE_LIST', 		false);
	define('ALLOW_BBCODE_ALIGN', 	false);
	define('ALLOW_BBCODE_URL', 		true);
	define('ALLOW_BBCODE_PHP', 		false);
	define('ALLOW_BBCODE_CODE', 		false);
	define('ALLOW_BBCODE_HTML', 		false);
}


// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_downloads', 'user', 'album', 'posting');

// get templates used by all actions
$globaltemplates = array(
	'GENERIC_SHELL', // @TODO: Move vB3 to vbDownloads shells
	'dbtech_downloads_SHELL',
	'dbtech_downloads_footer'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'download' => array(
		'dbtech_downloads_download',
		'dbtech_downloads_download_files',
		'dbtech_downloads_download_more',
		'dbtech_downloads_download_comments',
		'dbtech_downloads_download_mirrors',
		'dbtech_downloads_download_rating',
		'dbtech_downloads_download_screenshot'
	),
	'home' => array(
		'dbtech_downloads_home',
		'dbtech_downloads_home_categories',
		'dbtech_downloads_home_subcategories',
		'dbtech_downloads_home_recent',
		'dbtech_downloads_home_top',
		'dbtech_downloads_home_rated',
		'dbtech_downloads_home_rated_pro',
		'dbtech_downloads_home_recent_pro',
		'dbtech_downloads_home_top_pro'
	),
	
	'upload' => array(
		'dbtech_downloads_upload',
		'dbtech_downloads_upload_private_pro',
		'dbtech_downloads_upload_extinfo'
	),
	
	'favourites' => array(
		'dbtech_downloads_favourites',
		'dbtech_downloads_favourites_bits'
	),
	
	'modcp' => array(
		'dbtech_downloads_modcp',
		'dbtech_downloads_modcp_reports',
		'dbtech_downloads_modcp_moderation'
	),
	
	'listings' => array(
		'dbtech_downloads_listings',
		'dbtech_downloads_listings_bits'
	),
	
	'editdownload' => array(
		'dbtech_downloads_edit_file',
		'dbtech_downloads_edit_file_files',
		'dbtech_downloads_edit_private_pro',
		'dbtech_downloads_upload_extinfo'
	),
	
	'password' => array(
		'dbtech_downloads_passpage'
	),

	'search' => array(
		'dbtech_downloads_search',
		'dbtech_downloads_search_bits'
	),

    'file' => array(
        'dbtech_downloads_delay'
    )
);

// get special data templates from the datastore
$specialtemplates = array(
	'dbtech_downloads_categories',
	'dbtech_downloads_modules'
);

if ($_GET['do'] == 'upload' || $_GET['do'] == 'editdownload') {
	define('GET_EDIT_TEMPLATES', true);
	array_push($specialtemplates, 'smiliecache');
	array_push($specialtemplates, 'bbcodecache');
}

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'home';
}


// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/dbtech/downloads/core/class_download.php');


if ($vbulletin->userinfo['dbtech_downloads_banned'] == 1) {
	print_no_permission();
}

if (count($vbulletin->dbtech_downloads_categories) == 0) {
	standard_error('You must add at least one category and configure it for the system to function.');
}

$dbtech_class = 'Downloads';

if (file_exists(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php')) {
    require_once(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php');
    
    $dbtech_class = 'Downloads_Pro';
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'home';
}
		$isPro = false;
		/*DBTECH_PRO_START*/
		$isPro = true;
		/*DBTECH_PRO_END*/  

if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech')
{
	$_info = array(
		'version' 		=> '1.3.7',
		'versionnumber' => 137,
		'pro'			=> $isPro,
		'vbversion'		=> $vbulletin->versionnumber
	
	);
	$_content = array();
	foreach ($_info as $key => $val)
	{
		$_content[] = '"' . $key . '":"' . $val . '"';
	}
	echo '{' . implode(',', $_content) . '}';
	die();
}


// Strip non-valid characters
$action = preg_replace("/[^a-zA-Z0-9-_]/", "", $action);

if (!class_exists('vB_Template'))
{
	require_once(DIR . '/dbtech/downloads/core/class_template.php');
}

if (intval($vbulletin->versionnumber) == 4) {
        if ($vbulletin->options['storecssasfile'] == true) {
            $includecss = array(
                'dbtech_downloads'
            );
        } else {
            $includecss = 'dbtech_downloads.css';
        }
} else {
	$headinclude .= '<style type="text/css">';
	
	$csstemp = vB_Template::create('dbtech_downloads.css');
	
	$headinclude .= $csstemp->render();
	$headinclude .= '</style>';
}


if (version_compare('4.1.0', $vbulletin->versionnumber, '>=')) {
	$includecss = array('dbtech_downloads.css');
}


$navbits = array(
	$vbulletin->options['dbtech_downloads_link'] . '.php' => $vbphrase['dbtech_downloads']
);

Downloads::init($vbulletin);
$globalmodule = Downloads::load_module('global');

$pagetitle = $vbphrase['dbtech_downloads']; // SET DEFAULT TITLE
$JAVASCRIPT_INCLUDE = '';

if (file_exists(DIR . '/dbtech/downloads/actions/' . $action . '.php'))
{
	if (file_exists(DIR . '/dbtech/downloads_pro/actions/' . $action . '.php'))
	{
		// Include the selected file
		include_once(DIR . '/dbtech/downloads_pro/actions/' . $action . '.php');
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/downloads/actions/' . $action . '.php');	
	}
}
else
{
	// Throw error from invalid action
		standard_error(fetch_error('dbtech_downloads_invalid_action')); 
}

if (intval($vbulletin->versionnumber) == 3)
{
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	// Create navbits
	$navbar = render_navbar_template(construct_navbits($navbits));
}

// Prepare copyright footer
$templater = vB_Template::create('dbtech_downloads_footer');
	$templater->register('year', date('Y'));
$HTML .= $templater->render();

$headinclude .= '	
<script type="text/javascript" src="dbtech/downloads/clientscript/downloads.js"></script>
<script src="clientscript/yui/animation/animation-min.js" type="text/javascript"></script>

<script type="text/javascript">
	var Downloads = new Downloads_Obj();
	var THIS_PAGE = "' . $vbulletin->options['dbtech_downloads_link'] . '";
</script>
';

$footer .= '<script type="text/javascript">
	' . $JAVASCRIPT_INCLUDE . '
	</script>';

// Finish the main template

	if (intval($vbulletin->versionnumber) == 4) {
		$templater = vB_Template::create('dbtech_downloads_SHELL');
	} else {
		$templater = vB_Template::create('GENERIC_SHELL');	
	}
	$templater->register_page_templates();
	$templater->register('HTML', 				$HTML);
	$templater->register('navbar', 				$navbar);
	$templater->register('pagetitle', 			$pagetitle);
	$templater->register('template_hook', 		$template_hook);
	$templater->register('includecss', 			$includecss);
	$templater->register('headinclude',			$headinclude);
	$templater->register('footer',				$footer);
print_output($templater->render());

?>